﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace VeteransAffairs.Registries.BusinessAHOBPR.Tests
{
    [TestClass()]
    public class EligibleCountriesValidatorTests
    {
        /// <summary>
        /// Valid Exposed Dates:  "01/01/1990" to present
        /// Valid First Gulf War Veteran Dates:  "08/01/1990" to  "09/30/1991", 
        /// </summary>

        [TestMethod]
        public void FirstGulfWar_With_Upper_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "IRAQ"
            };
            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void FirstGulfWar_With_Lower_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "iraq"
            };
            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void FirstGulfWar_With_Lower_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "iz"
            };
            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void FirstGulfWar_With_Upper_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "IZ"
            };
            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void ExposedCountries_With_Upper_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "IRAQ"
            };
            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void ExposedCountries_With_Lower_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "iraq"
            };
            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void ExposedCountries_With_Lower_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "iz"
            };
            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }

       
         [TestMethod]
        public void ExposedCountries_With_Upper_Case_Country_Exposed_List_Name_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "AFGHANISTAN"
            };
            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void ExposedCountries_With_Upper_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            REGISTRANT_DEPLOYMENT deployment = new REGISTRANT_DEPLOYMENT
            {
                DEPLOYMENT_START_DATE = DateTime.Parse("1990-02-02"),
                DEPLOYMENT_END_DATE = DateTime.Parse("1990-11-11"),
                DEPLOYMENT_COUNTRY = "DJ"
            };
            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void DateRange_FirstGulfWar_With_Upper_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange(
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "IRAQ";

            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void DateRange_FirstGulfWar_With_Lower_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "iraq";

            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void DateRange_FirstGulfWar_With_Lower_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "iz";

            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void DateRange_FirstGulfWar_With_Upper_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "IZ";

            var cut = EligibilityValidatorFactory.CreateFirstGulfWarValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void DateRange_ExposedCountries_With_Upper_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "IRAQ";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void DateRange_ExposedCountries_With_Lower_Case_Country_Name_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "iraq";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void InEligible_DateRange_For_ExposedCountries_With_Lower_Case_Country_Name_And_Correct_Dates_Is_NOT_Eligible()
        {
            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1975-02-02"),
                DateTime.Parse("1989-11-11"));
            string deploymentCountry = "iraq";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(false, actual);
        }

        [TestMethod]
        public void DateRange_AHOBPR_Eligibile_With_Lower_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "iz";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }


        [TestMethod]
        public void DateRange_AHOBPR_Eligibile_With_Upper_Case_Country_Exposed_List_Name_And_Correct_Dates_IsEligible()
        {
            
            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "AFGHANISTAN";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void DateRange_AHOBPR_Eligibile_With_Upper_Case_Country_Code_And_Correct_Dates_IsEligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1990-02-02"),
                DateTime.Parse("1990-11-11"));
            string deploymentCountry = "DJ";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void InEligible_DateRange_ExposedCountries_With_Upper_Case_Country_Code_Is_NOT_Eligible()
        {

            DateRange deployment = new DateRange
            (
                 DateTime.Parse("1989-02-02"),
                DateTime.Parse("1989-04-02"));
            string deploymentCountry = "DJ";

            var cut = EligibilityValidatorFactory.CreateAHOBPREligibilityValidator();
            var actual = cut.IsEligible(deployment, deploymentCountry);
            Assert.AreEqual(false, actual);
        }

    }
}